




/**********************************************************************************************
 *                                                                                            *
 * Ex4.      :   Read Status Detect  at Connecter OUT of Module                               *
 *                                                                                            *
 *              -Befor Run program Save Distance Detect at 10 cm on Module                    *
 *              -Status Detect=0 when Current Distance < Detect Distance(10cm)                * 
 *                                                                                            *
 **********************************************************************************************
 *                                                                                            *
 *                                                                                            *
 * Target MCU     : ATMEL AVR-MEGA128 (ET-BASE AVR ATMEGA128 r3 Board)                        *
 *                : X-TAL : 16 MHz                                                            *
 *                                                                                            *
 * Editor         : AVR Studio 4.15 Build 623                                                 *
 * Compiler       : WinAVR-20081205                                                           *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 * Last Update    : 09/October/2014                                                           *
 *                                                                                            *
 * Port Interface :  --- MCU-AVR Mega 128 ---           --- Module REMOTE DISTANCE ---        *
 *                                                                                            *
 *                      PB0..PB7(Output)          Connect     LED Common Anode                *
 *                      PC0(Input)(Read Status)   Connect     P1 Connector OUT                *
 *                                                            Disable Filter                  *
 *                                                        5V                                  *
 *                                                       -+-                                  *
 *                                         \\             |                                   *
 *             (Active'0') PB0------------|<|-------------+                                   *
 *                                    .                   |                                   *
 *                                    .                   |                                   *
 *                                    .    \\             |                                   *
 *                         PB7------------|<|-------------+                                   *
 *                                                                                            * 
 *                                                                                            * 
 *   Operation  : Read Status Detector by Set Distance for Detect at 10 cm.                   *
 *                When Current Distance less 10 cm LED PortB ON if more 10 cm LED PortB OFF   *   
 *                                                                                            *
 **********************************************************************************************/
 

#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit
#include <avr/pgmspace.h>            //for progrm data to Area Flash
#include <avr/interrupt.h>           //Interrupt Service routine

#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)
#include<util/delay.h>               //util_delay



//-------------- Function Delay_ms ------------------

void delay_ms(unsigned int i)
 {
   for(;i>0;i--)
      _delay_ms(1);
 }





/********************************************************
 **                                                    **
 **                        MAIN                        **   
 **                                                    **
 ********************************************************/


 int main (void) 
  {
    char dt ;
  
    delay_ms(200)      ;  //Wait Module ET-Remote Distance Ready when Power On
       
    
    DDRB = 0xFF        ; //Set PORTB=OUTPUT for Show Statust Detect
	DDRC = 0x00        ; //Set PORTC=Input by PC0 Read Status Detect
	PORTC= 0x01        ; //Full Up PC0 

//----------------- Start Read Status Detecter --------------

    while(1) 
    {   
        dt = PINC & 0x01    ; //Read PortC  by Mark bit PC0 for Read Status Detect 

		if(dt == 0)           //Check Status Detect if Current Distance < 10 Cm , dt = 0
		 PORTB = 0x00       ; //LED PORTB ON
        else
		 PORTB = 0xFF       ; //LED PORTB OFF

	}//while

  }



